require('./string'); // load  generic string prototypes
let environment = {}; // environment object
// console may be not available e.g. in custom service requests
let _print, cache, property, stringify;

if (typeof process !== 'undefined') {
  ////////////////////////////////////////////
  // setup nodejs based runtime environment //
  ////////////////////////////////////////////

  environment.name = 'node';
  environment.debug = process.env.CDEV_NCORE_DEBUG === 'true';

  stringify = obj => {
    return JSON.stringify(obj, null, 2);
  };
  
  _print = console.log;

} else {
  //////////////////////////////////////////////////
  // setup agorum/Rhino based runtime environment //
  //////////////////////////////////////////////////

  property = require('common/property');
  cache = require('common/cache')('CDEV_NCORE');

  environment.name = 'agorum';
  environment.debug = !!cache.read('CDEV_NCORE_DEBUG');

  // use console log for diagnostic output check if log-channel is available
  try {
    _print = require('/agorum/roi/customers/cdev.console/js/log-channel').log;
  } catch (err) {
    try {
      _print = require('/agorum/roi/customers/cdev.core/js/log-channel').log;
    } catch (err) {
      // eslint-disable-next-line no-unused-vars
      _print = console ? console.log : (args) => {return null;};
    }
  }

  stringify = obj => {
    if (obj === null) return 'null';
    if (typeof obj === 'object') {
      if (obj.className && obj.name && obj.ID) {
        return property
          .from({
            name: obj.name,
            ID: obj.ID,
            UUID: obj.UUID,
            className: obj.className,
          })
          .toPrettyString();
      } else {
        let out;
        try {
          out = property.from(obj).toPrettyString();
        } catch (err) {
          return 'null';
        }
        return out;
      }
    }
    return obj;
  };
}

//////////////////////////////////////////
// end of environment specific settings //
//////////////////////////////////////////

/**
 * Determines whether a given reference is an object.
 * @memberof path
 * @function isObject
 * @param {*} ref - The reference to check.
 * @returns {boolean} True if the reference is an object with a className property, false otherwise.

const isObject = ref => {
  return typeof ref === 'object' && ref !== null && 'className' in ref;
};
 */

/**
 * agorum console log wrapper (without debug flag checking)
 * @param {...*} var_args - variable list of arguments
 * @returns void
 */
function print() {
  let length = arguments.length;
  if (typeof process === 'undefined') {
    // stringify agorum objects objects
    let out = [];
    for (let i = 0; i < length; i++) {
      let arg = arguments[i];
      /*
      let result = isObject(arg) ? stringify(arg) : typeof arg === 'string' ? arg : JSON.stringify(arg, null, 2);
      out.push(result && result.replace(/"(\w+)"\s*:/g, '$1:').replace(/:\s*"([^"]*)"/g, ": '$1'"));
      */
      out.push(typeof arg === 'object' ? stringify(arg) : arg);  
    }
    _print(out.join(' '));
  } else {
    // just forwrd arguments to console.log
    let args = [];
    for (let i = 0; i < length; i++) {
      args.push(arguments[i]);
    }
    _print.apply(null, args);
  }
}

/**
 * agorum console log wrapper (check debug flag from cache)
 * @param {...*} var_args - variable list of arguments
 * @returns void
 */
function debug() {
  if (environment.debug) {
    let args = [];
    for (let i = 0; i < arguments.length; i++) args.push(arguments[i]);
    print.apply(null, args);
  }
}

module.exports = {
  environment: environment,
  print: print,
  debug: debug,
};
